//*************************************************************************************************************************************
//
//  Sample Program for Flase and SRAM Memory
//
//  Target Machine : CPT-711
//
//  Function:
//  int  RamSize(void)                                                        : To check the size of data memory(SRAM).
//  long free_memory(void)                                                    : Get free memory size information.
//  int  FlashSize(void)                                                      : To check the size of flash memory.
//  int  EraseSector(void *sector_start_addr)                                 : To erase a whole sector of flash memory.
//  int  WriteFlash(void *target_addr, void *source_addr, unsigned long size) : To write data to the flash memory.
//
//  SYNTECH INFORMATION CO., LTD.
//
//*************************************************************************************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\lib\711lib.h"

void main (void)
    {
    int   i, iRamSize, iFlashSize;
    long  lSRamMemory;
    char  sFlash[10];
    unsigned char  *cReadFlash;

    clr_scr ();
    gotoxy (3,0);
    puts ("MEMORY TEST");

    iRamSize = RamSize();
    gotoxy (0,2);
    printf ("SRAM SIZE:%d KB", iRamSize);

    lSRamMemory = free_memory();
    gotoxy (0,3);
    printf ("SRAM MEMORY:%ld B", lSRamMemory);

    iFlashSize = FlashSize();
    gotoxy (0,5);
    printf ("FLASH SIZE:%d KB", iFlashSize);

    EraseSector ((void *)0xf60000);
    strcpy (sFlash, "CIPHER");
    WriteFlash ((void *)0xf60000, sFlash, 6);

    cReadFlash = (void *)0xf60000;
    for (i=0; i<6; i++)
        sFlash[i] = *cReadFlash++;

    sFlash[i] = 0;
    gotoxy (0,6);
    printf ("READ FLASH:%s",sFlash);

    while (getchar() != KEY_ESC);
    }

//-------------------------------------------------------------------------//
